///////////////////////////////////////////////////////////////////////////////////////////

unsigned long CRCTable[256]; // CRC Lookup Table Array

///////////////////////////////////////////////////////////////////////////////////////////

void InitializeCRCTable(void);
unsigned long Reflect(unsigned long, char);
DWORD PartialCRC(unsigned long, unsigned char *, DWORD);

///////////////////////////////////////////////////////////////////////////////////////////
// This Is The Official Polynomial Used By CRC-32 In PKZip, WinZip and Ethernet.

void InitializeCRCTable()
{
	unsigned long Polynomial = 0x04c11db7;

	// 256 Values Representing ASCII Character Codes.
	for(int Loop1 = 0; Loop1 <= 0xFF; Loop1++)
	{
		CRCTable[Loop1] = Reflect(Loop1, 8) << 24;

		for (int Loop2 = 0; Loop2 < 8; Loop2++)
			CRCTable[Loop1] = (CRCTable[Loop1] << 1) ^ (CRCTable[Loop1] & (1 << 31) ? Polynomial : 0);

		CRCTable[Loop1] = Reflect(CRCTable[Loop1], 32);
	}
}

///////////////////////////////////////////////////////////////////////////////////////////
// Reflection Is A Requirement For The Official CRC-32 Standard.
// You Can Create CRCs Without It, But They Won't Conform To The Standard.

unsigned long Reflect(unsigned long Reflect, char Character)
{
	unsigned long Value = 0;

	// Swap Bit 0 For Bit 7 Bit 1 For Bit 6, Etc....
	for(int Loop = 1; Loop < (Character + 1); Loop++)
	{
		if(Reflect & 1) Value |= 1 << (Character - Loop);

		Reflect >>= 1;
	}

	return Value;
}

///////////////////////////////////////////////////////////////////////////////////////////
// This function uses the CRCTable lookup table to generate a CRC for xData
// You must keep adding the values this function returns.
// When finished XOR the value by 0xffffffff

unsigned long PartialCRC(unsigned long InputCRC, char *sBuffer, int xLength)
{
	// Be Sure To Use Unsigned Variables,
	// Because Negative Values Introduce High Bits
	// Where Zero Bits Are Required.

    if(xLength == 0)
        return 0;

    unsigned char *Buffer = (unsigned char *) sBuffer;

	while(xLength--)
        InputCRC = (InputCRC >> 8) ^ CRCTable[(InputCRC & 0xFF) ^ *Buffer++];

	return(InputCRC);
}

///////////////////////////////////////////////////////////////////////////////////////////

